#ifndef _OPCODES_H_
#define _OPCODES_H_

#ifndef DEFINE_OPCODE
#define DEFINE_OPCODE(name, number, params) extern const SCRIPT_COMMAND name
#endif

namespace GTASA
{

/*
 * Opcodes
 */
DEFINE_OPCODE(nop, 0x0000, "");
DEFINE_OPCODE(jump, 0x0002, "i");
DEFINE_OPCODE(shake_camera, 0x0003, "i");
DEFINE_OPCODE(setgi, 0x0004, "ii");
DEFINE_OPCODE(setgf, 0x0005, "ff");
DEFINE_OPCODE(setli, 0x0006, "ii");
DEFINE_OPCODE(setlf, 0x0007, "ff");
DEFINE_OPCODE(addgi, 0x0008, "ii");
DEFINE_OPCODE(addgf, 0x0009, "f");
DEFINE_OPCODE(addli, 0x000A, "ii");
DEFINE_OPCODE(addlf, 0x000B, "ii");
DEFINE_OPCODE(subgi, 0x000C, "ii");
DEFINE_OPCODE(subgf, 0x000D, "ff");
DEFINE_OPCODE(subli, 0x000E, "ii");
DEFINE_OPCODE(sublf, 0x000F, "ff");
DEFINE_OPCODE(mulgi, 0x0010, "ii");
DEFINE_OPCODE(mulgf, 0x0011, "ff");
DEFINE_OPCODE(mulli, 0x0012, "ii");
DEFINE_OPCODE(mullf, 0x0013, "ff");
DEFINE_OPCODE(divgi, 0x0014, "ii");
DEFINE_OPCODE(divgf, 0x0015, "ff");
DEFINE_OPCODE(divli, 0x0016, "ii");
DEFINE_OPCODE(divlf, 0x0017, "ff");
DEFINE_OPCODE(gtgi, 0x0018, "ii");
DEFINE_OPCODE(gtli, 0x0019, "ii");
DEFINE_OPCODE(gtig, 0x001A, "ii");
DEFINE_OPCODE(gtil, 0x001B, "ii");
DEFINE_OPCODE(gtgg, 0x001C, "ii");
DEFINE_OPCODE(gtll, 0x001D, "ii");
DEFINE_OPCODE(gtgl, 0x001E, "ii");
DEFINE_OPCODE(gtlg, 0x001F, "ii");
DEFINE_OPCODE(gtgf, 0x0020, "ff");
DEFINE_OPCODE(gtlf, 0x0021, "ff");
DEFINE_OPCODE(gtfg, 0x0022, "ff");
DEFINE_OPCODE(gtfl, 0x0023, "ff");
DEFINE_OPCODE(gtggf, 0x0024, "ff");
DEFINE_OPCODE(gtllf, 0x0025, "ff");
DEFINE_OPCODE(gtglf, 0x0026, "ff");
DEFINE_OPCODE(gtlgf, 0x0027, "ff");
DEFINE_OPCODE(gtegi, 0x0028, "ii");
DEFINE_OPCODE(gteli, 0x0029, "ii");
DEFINE_OPCODE(gteig, 0x002A, "ii");
DEFINE_OPCODE(gteil, 0x002B, "ii");
DEFINE_OPCODE(gtegg, 0x002C, "ii");
DEFINE_OPCODE(gtell, 0x002D, "ii");
DEFINE_OPCODE(gtegl, 0x002E, "ii");
DEFINE_OPCODE(gtelg, 0x002F, "ii");
DEFINE_OPCODE(gtegf, 0x0030, "ff");
DEFINE_OPCODE(gtelf, 0x0031, "ff");
DEFINE_OPCODE(gtefg, 0x0032, "ff");
DEFINE_OPCODE(gtefl, 0x0033, "ff");
DEFINE_OPCODE(gteggf, 0x0034, "ff");
DEFINE_OPCODE(gtellf, 0x0035, "ff");
DEFINE_OPCODE(gteglf, 0x0036, "ff");
DEFINE_OPCODE(gtelgf, 0x0037, "ff");
DEFINE_OPCODE(egi, 0x0038, "ii");
DEFINE_OPCODE(eli, 0x0039, "ii");
DEFINE_OPCODE(egg, 0x003A, "ii");
DEFINE_OPCODE(ell, 0x003B, "ii");
DEFINE_OPCODE(egl, 0x003C, "ii");
DEFINE_OPCODE(egf, 0x0042, "ff");
DEFINE_OPCODE(elf, 0x0043, "ff");
DEFINE_OPCODE(eggf, 0x0044, "ff");
DEFINE_OPCODE(ellf, 0x0045, "ff");
DEFINE_OPCODE(eglf, 0x0046, "ff");
DEFINE_OPCODE(jump_if_false, 0x004D, "i");
DEFINE_OPCODE(create_thread, 0x004F, "");
DEFINE_OPCODE(gosub, 0x0050, "i");
DEFINE_OPCODE(_return, 0x0051, "");
DEFINE_OPCODE(addgg, 0x0058, "ii");
DEFINE_OPCODE(addggf, 0x0059, "ff");
DEFINE_OPCODE(addll, 0x005A, "ii");
DEFINE_OPCODE(addllf, 0x005B, "ff");
DEFINE_OPCODE(addlg, 0x005C, "ii");
DEFINE_OPCODE(addlgf, 0x005D, "ff");
DEFINE_OPCODE(addgl, 0x005E, "ii");
DEFINE_OPCODE(addglf, 0x005F, "ff");
DEFINE_OPCODE(subgg, 0x0060, "ii");
DEFINE_OPCODE(subggf, 0x0061, "ff");
DEFINE_OPCODE(subll, 0x0062, "ii");
DEFINE_OPCODE(subllf, 0x0063, "ff");
DEFINE_OPCODE(sublg, 0x0064, "ii");
DEFINE_OPCODE(sublgf, 0x0065, "ff");
DEFINE_OPCODE(subgl, 0x0066, "ii");
DEFINE_OPCODE(subglf, 0x0067, "ff");
DEFINE_OPCODE(mulgg, 0x0068, "ii");
DEFINE_OPCODE(mulggf, 0x0069, "ff");
DEFINE_OPCODE(mulll, 0x006A, "ii");
DEFINE_OPCODE(mulllf, 0x006B, "ff");
DEFINE_OPCODE(mullg, 0x006C, "ii");
DEFINE_OPCODE(mullgf, 0x006D, "ff");
DEFINE_OPCODE(mulgl, 0x006E, "ii");
DEFINE_OPCODE(mulglf, 0x006F, "ff");
DEFINE_OPCODE(divgg, 0x0070, "ii");
DEFINE_OPCODE(divggf, 0x0071, "ff");
DEFINE_OPCODE(divll, 0x0072, "ii");
DEFINE_OPCODE(divllf, 0x0073, "ff");
DEFINE_OPCODE(divlg, 0x0074, "ii");
DEFINE_OPCODE(divlgf, 0x0075, "ff");
DEFINE_OPCODE(divgl, 0x0076, "ii");
DEFINE_OPCODE(divglf, 0x0077, "ff");
DEFINE_OPCODE(addgf_time, 0x0078, "ff");
DEFINE_OPCODE(addlf_time, 0x0079, "ff");
DEFINE_OPCODE(addggf_time, 0x007A, "ff");
DEFINE_OPCODE(addllf_time, 0x007B, "ff");
DEFINE_OPCODE(addglf_time, 0x007C, "ff");
DEFINE_OPCODE(addlgf_time, 0x007D, "ff");
DEFINE_OPCODE(subgf_time, 0x007E, "ff");
DEFINE_OPCODE(sublf_time, 0x007F, "ff");
DEFINE_OPCODE(subggf_time, 0x0080, "ff");
DEFINE_OPCODE(subllf_time, 0x0081, "ff");
DEFINE_OPCODE(subglf_time, 0x0082, "ff");
DEFINE_OPCODE(sublgf_time, 0x0083, "ff");
DEFINE_OPCODE(setgg, 0x0084, "ii");
DEFINE_OPCODE(setll, 0x0085, "ii");
DEFINE_OPCODE(setggf, 0x0086, "ff");
DEFINE_OPCODE(setllf, 0x0087, "ff");
DEFINE_OPCODE(setglf, 0x0088, "ff");
DEFINE_OPCODE(setlgf, 0x0089, "ff");
DEFINE_OPCODE(setgl, 0x008A, "ff");
DEFINE_OPCODE(setlg, 0x008B, "ff");
DEFINE_OPCODE(setgigf, 0x008C, "if");
DEFINE_OPCODE(setgfgi, 0x008D, "fi");
DEFINE_OPCODE(setlilf, 0x008E, "if");
DEFINE_OPCODE(setlfli, 0x008F, "fi");
DEFINE_OPCODE(setgilf, 0x0090, "if");
DEFINE_OPCODE(setgfli, 0x0091, "fi");
DEFINE_OPCODE(setliff, 0x0092, "if");
DEFINE_OPCODE(setlfgi, 0x0093, "fi");
DEFINE_OPCODE(absg, 0x0094, "i");
DEFINE_OPCODE(absl, 0x0095, "i");
DEFINE_OPCODE(absgf, 0x0096, "f");
DEFINE_OPCODE(abslf, 0x0097, "f");
DEFINE_OPCODE(randf_0to1, 0x0098, "f");
DEFINE_OPCODE(randi_0to65535, 0x0099, "i");
DEFINE_OPCODE(get_actor_coords, 0x00A0, "ivvv");
DEFINE_OPCODE(put_actor_at, 0x00A1, "ifff");
DEFINE_OPCODE(get_car_coords, 0x00AA, "ivvv");
DEFINE_OPCODE(put_car_at, 0x00AB, "ifff");
DEFINE_OPCODE(_if, 0x00D6, "i");
DEFINE_OPCODE(store_actor_car, 0x00D9, "iv");
DEFINE_OPCODE(is_actor_driving_car, 0x00DB, "ii");
DEFINE_OPCODE(is_actor_driving, 0x00DF, "i");
DEFINE_OPCODE(is_key_pressed, 0x00E1, "ii");
DEFINE_OPCODE(get_key_pressed, 0x00E2, "iiv");
DEFINE_OPCODE(is_actor_near_point_3d_on_foot, 0x00FF, "iffffffi");
DEFINE_OPCODE(get_actor_z_angle, 0x0172, "iv");
DEFINE_OPCODE(set_actor_z_angle, 0x0173, "if");
DEFINE_OPCODE(get_car_z_angle, 0x0174, "iv");
DEFINE_OPCODE(force_weather, 0x01B5, "i");
DEFINE_OPCODE(release_model, 0x0249, "i");
DEFINE_OPCODE(remove_actor_from_car_and_put_at, 0x0362, "ifff");
DEFINE_OPCODE(get_actor_car, 0x03C0, "iv");
DEFINE_OPCODE(get_car_model, 0x0441, "iv");
DEFINE_OPCODE(remove_actor_from_car, 0x0622, "ii");
DEFINE_OPCODE(end_scene_skip, 0x0701, "");
DEFINE_OPCODE(start_scene_skip_to, 0x0707, "i");
DEFINE_OPCODE(get_active_interior, 0x077E, "v");
DEFINE_OPCODE(put_jetpack_on_actor, 0x07A7, "i");
DEFINE_OPCODE(link_car_to_interior, 0x0840, "ii");
DEFINE_OPCODE(link_actor_to_interior, 0x0860, "ii");
DEFINE_OPCODE(create_entrance_marker_at, 0x0A40, "fffiv");
DEFINE_OPCODE(destroy_entrance_marker, 0x0A41, "i");


/*
 * Courtesy of spookie's code
 */
DEFINE_OPCODE(request_model, 0x0247, "i");				// (CAR_*|BIKE_*|BOAT_*|WEAPON_*|OBJECT_*)
DEFINE_OPCODE(load_requested_models, 0x038B, "");		// -/-
DEFINE_OPCODE(create_car, 0x00A5, "ifffv");				// (CAR_*|BIKE_*|BOAT_*), x, y, z, var_car
DEFINE_OPCODE(load_special_actor, 0x023C, "is");		// SPECIAL_*, MODEL_*
DEFINE_OPCODE(create_actor, 0x009A, "iifffv");			// PEDTYPE_*, #MODEL, x, y, z, var_actor
DEFINE_OPCODE(destroy_actor_fading, 0x034F, "v");		// var_actor
DEFINE_OPCODE(set_weather, 0x01B6, "i");				// WEATHER_*
DEFINE_OPCODE(set_fade_color, 0x0169, "iii");			// Red(0-255), Green(0-255), Blue(0-255)
DEFINE_OPCODE(fade, 0x016A, "ii");						// (time in ms), FADE_*
DEFINE_OPCODE(is_fading, 0x016B, "");					// -/-
DEFINE_OPCODE(freeze_player, 0x01B4, "vi");				// PLAYER_CHAR, Freeze(1/0)
DEFINE_OPCODE(name_thread, 0x03A4, "s");				// "MAIN"
DEFINE_OPCODE(set_max_wanted_level, 0x01F0, "i");		// MaxLevel
DEFINE_OPCODE(set_wasted_busted_check, 0x0111, "i");	// Check(1/0)
DEFINE_OPCODE(set_current_time, 0x00C0, "ii");			// Hours, Minutes
DEFINE_OPCODE(refresh_screen, 0x04E4, "ff");			// x, y
DEFINE_OPCODE(set_camera, 0x03CB, "fff");				// x, y, z
DEFINE_OPCODE(create_player, 0x0053, "ifffv");			// 0, x, y, z, PLAYER_CHAR
DEFINE_OPCODE(create_actor_from_player, 0x01F5, "vv");	// PLAYER_CHAR, PLAYER_ACTOR
DEFINE_OPCODE(set_actor_skin, 0x0352, "vs");			// var_actor, MODEL_*
DEFINE_OPCODE(refresh_actor_skin, 0x0353, "v");			// var_actor
DEFINE_OPCODE(select_interior, 0x04BB, "i");			// INTERIOR_*
DEFINE_OPCODE(make_actor_leave_vehicle, 0x03E2, "v");	// var_actor
DEFINE_OPCODE(clear_actor_objective, 0x011C, "v");		// var_actor
DEFINE_OPCODE(send_actor_to_car, 0x01D4, "vv");			// var_actor, var_car
DEFINE_OPCODE(send_actor_to_car_driver, 0x01D5, "vv");	// var_actor, var_car
DEFINE_OPCODE(set_car_color, 0x0229, "vii");			// var_car col1 col2
DEFINE_OPCODE(wait, 0x0001, "i");						// time_in_ms
DEFINE_OPCODE(create_thread_wb, 0x00D7, "iz");			// StartIP (4F)
DEFINE_OPCODE(end_thread, 0x004E, "");					// -/-
DEFINE_OPCODE(destroy_car, 0x00A6, "v");				// var_car
DEFINE_OPCODE(set_car_z_angle, 0x0175, "vf");			// var_car, angle
DEFINE_OPCODE(car_relative_coordinates, 0x0407, "vfffvvv");// var_car, x, y, z, var_x, var_y, var_z
DEFINE_OPCODE(set_car_max_speed, 0x00AD, "vf");			// var_car, speed
DEFINE_OPCODE(is_model_available, 0x0248, "i");			// #MODEL
DEFINE_OPCODE(create_actor_in_driverseat, 0x0129, "viiv");	// var_car, pedtype, #MODEL, var_actor
DEFINE_OPCODE(create_actor_in_passenger, 0x01c8, "viiiv");	// var_car, pedtype, #MODEL, seat, var_actor
DEFINE_OPCODE(drive_car_to_point1, 0x02C2, "vfff");		// var_car, x, y, z
DEFINE_OPCODE(car_ignore_traffic, 0x00AE, "vi");		// var_car, flag
DEFINE_OPCODE(set_car_immune_to_nonplayer, 0x02aa, "vi");// var_car, immune(1/0)
DEFINE_OPCODE(give_actor_weapon, 0x01B2, "vii");		// var_actor, weapon, ammo
DEFINE_OPCODE(reset_actor_flags, 0x01ED, "v");			// var_actor
DEFINE_OPCODE(set_actor_ped_stats, 0x0243, "vi");		// var_actor, pedstats
DEFINE_OPCODE(toggle_actor_wander, 0x0319, "vi");		// var_actor, wander(1/0)
DEFINE_OPCODE(play_music, 0x0394, "i");					// music
DEFINE_OPCODE(clear_player_wanted_level, 0x0110, "v");	// PLAYER_CHAR
DEFINE_OPCODE(set_car_door_status, 0x020A, "vi");		// var_car, status
DEFINE_OPCODE(remove_references_to_actor, 0x01C2, "v");	// var_actor
DEFINE_OPCODE(remove_references_to_car, 0x01C3, "v");	// var_car
DEFINE_OPCODE(set_player_wanted_level, 0x010D, "vi");	// PLAYER_CHAR, level
DEFINE_OPCODE(set_player_health, 0x0222, "vi");			// PLAYER_CHAR, health
DEFINE_OPCODE(get_car_health, 0x0227, "vv");			// var_car, var_health
DEFINE_OPCODE(text_styled, 0x00BA, "sii");				// TEXT, time, style
DEFINE_OPCODE(text_now, 0x00BC, "sii");					// TEXT, time, style
DEFINE_OPCODE(text_1number_styled, 0x01E3, "siii");		// TEXT, number, time, style
DEFINE_OPCODE(toggle_car_siren, 0x0397, "vi");			// var_car, siren(1/0)
DEFINE_OPCODE(toggle_widescreen, 0x02A3, "i");			// widescreen(1/0)
DEFINE_OPCODE(set_camera_behind_player, 0x0373, "");	// -/-
DEFINE_OPCODE(camera_on_vehicle, 0x0158, "vii");		// var_car, ukn, ukn
DEFINE_OPCODE(restore_camera, 0x015A, "");				// -/-
DEFINE_OPCODE(point_camera, 0x0160, "fffi");			// x, y, z, type
DEFINE_OPCODE(restore_camera_jumpcut, 0x02EB, "");		// -/-
DEFINE_OPCODE(set_camera_position, 0x015F, "ffffff");	// x, y, z, vx, vy, vz
DEFINE_OPCODE(tie_actor_to_player, 0x01DF, "vv");		// var_actor, PLAYER_CHAR
DEFINE_OPCODE(tie_marker_to_car, 0x0161, "viiv");		// var_car, ukn, ukn, var_marker
DEFINE_OPCODE(tie_marker_to_actor, 0x0162, "viiv");		// var_actor, ukn, ukn, var_marker
DEFINE_OPCODE(disable_marker, 0x0164, "v");				// var_marker
DEFINE_OPCODE(set_marker_color, 0x0165, "vi");			// var_marker, color
DEFINE_OPCODE(set_marker_brightness, 0x0166, "vi");		// var_marker, brightness
DEFINE_OPCODE(create_marker, 0x0167, "fffiiv");			// x, y, z, ukn, ukn, var_marker
DEFINE_OPCODE(show_on_radar, 0x0168, "vi");				// var_marker, size
DEFINE_OPCODE(set_car_driver_behaviour, 0x00AF, "vi");	// var_car, behaviour
DEFINE_OPCODE(set_actor_to_kill_actor, 0x01C9, "vv");	// var_actor, var_actor
DEFINE_OPCODE(set_actor_to_kill_player, 0x01CA, "vv");	// var_actor, PLAYER_CHAR
DEFINE_OPCODE(is_actor_dead, 0x0118, "v");				// var_actor
DEFINE_OPCODE(player_near_point_on_foot, 0x00F6, "vffffffi");//	PLAYER_CHAR, x, y, z, rx, ry, rz, b
DEFINE_OPCODE(create_icon_marker_sphere, 0x02A7, "fffiv");
DEFINE_OPCODE(is_player_near_point_3d, 0x00F5, "vffffffi");// PLAYER_CHAR, x, y, z, rx, ry, rz, b
DEFINE_OPCODE(is_actor_near_point_3d, 0x00FE, "vffffffi");//	var_actor, x, y, z, rx, ry, rz, b
DEFINE_OPCODE(is_car_near_point_3d, 0x01AF, "vffffffi");//	var_car, x, y, z, rx, ry, rz, b
DEFINE_OPCODE(set_player_z_angle, 0x0171, "vf");
DEFINE_OPCODE(give_player_weapon, 0x01B1, "vii");		// PLAYER_CHAR, weapon, ammo
DEFINE_OPCODE(add_to_player_money, 0x0109, "vi");		// PLAYER_CHAR, money
DEFINE_OPCODE(restart_if_wasted_at, 0x016C, "ffff");	// x, y, z, a
DEFINE_OPCODE(restart_if_busted_at, 0x016D, "ffff");	// x, y, z, a

};
#undef DEFINE_OPCODE
#endif /* _OPCODES_H_ */